#!/bin/bash

mversion="V11.0"

modulesdir=usr/lib/asterisk/modules
soundsdir=var/lib/asterisk
echo "--- VXIasterisk $mversion Remove ---"

# Copy files

perm_dir=775
perm_files=664
perm_exec=775

src=.
dst=
#src=asterisk_$mversion
#dst=/tmp/asterisk_$mversion

echo "Stopping Openvxi.."
/etc/init.d/openvxi stop

echo "Removing binaries..."
rm -f $dst/usr/sbin/openvxi
rm -f $dst/usr/sbin/adminvxi
rm -f $dst/usr/sbin/safe_openvxi
if [ "1" = "1" ]; then \
	if [ -f /etc/redhat-release -o -f /etc/fedora-release ]; then \
		/sbin/chkconfig --del openvxi; \
		rm -f $dst/etc/rc.d/init.d/openvxi; \
 elif [ -f /etc/debian_version ]; then \
		/usr/sbin/update-rc.d -f openvxi remove; \
		rm -f $dst/etc/init.d/openvxi; \
	elif [ -f /etc/gentoo-release ]; then \
		/sbin/rc-update add openvxi default; \
		rm -f $dst/etc/init.d/openvxi; \
	elif [ -f /etc/mandrake-release ]; then \
  /sbin/chkconfig --del openvxi; \
  rm -f $dst/etc/rc.d/init.d/openvxi; \
	elif [ -f /etc/SuSE-release -o -f /etc/novell-release ]; then \
  /sbin/chkconfig --del openvxi; \
		rm -f $dst/etc/init.d/openvxi; \
	elif [ -f /etc/distro-release ]; then \
  /sbin/chkconfig --del openvxi; \
		rm -f $dst/etc/init.d/openvxi; \
	elif [ -f /etc/slackware-version ]; then \
		echo "Slackware is not currently supported, although an init script does exist for it." \
	else \
		echo "We could not uninstall init scripts for your distribution."; \
	fi \
else \
	echo "We could not uninstall init scripts for your operating system."; \
fi

echo "Removing configuration files..."
rm -f $dst/etc/openvxi/defaults.xml
rm -f $dst/etc/openvxi/client.cfg
if test ! -f $dst/etc/asterisk/client.cfg.sample ; then
rm -f $dst/etc/asterisk/client.cfg
fi
if test ! -f $dst/etc/asterisk/defaults.xml.sample ; then
rm -f $dst/etc/asterisk/defaults.xml.sample
fi
if test ! -f $dst/etc/asterisk/vxml.conf.sample ; then
rm -f $dst/etc/asterisk/vxml.conf.sample
fi

echo "Removing libraries..."
rm -f $dst/usr/lib/openvxi/lib*

echo "Removing modules..."
rm -f $dst/$modulesdir/app_vxml.so

echo "Installing sounds..."
rm -f $dst/$soundsdir/silence.h263
rm -f $dst/$soundsdir/silence.raw

echo "Removing directories..."
rm -rf $dst/usr/lib/openvxi
rm -rf $dst/etc/openvxi
rm -rf $dst/var/lib/openvxi

echo "--- VXIasterisk $mversion remove has finished ---"

