#!/bin/sh

mversion=V7-4

echo "--- Verbio for Asterisk $mversion Installation ---"

# Copy files

perm_dir=775
perm_files=664
perm_exec=775

src=.
dst=
#src=asterisk_$mversion
#dst=/tmp/asterisk_$mversion

echo "Creating directories..."
mkdir -p $dst/var/lib/asterisk/verbio/text
mkdir -p $dst/var/lib/asterisk/verbio/gram
mkdir -p $dst/var/lib/asterisk/verbio/audio

echo "Installing binaries..."
install -m $perm_dir $src/bin/verbiot2f $dst/usr/bin/

echo "Installing HTTP access..."
mkdir -p $dst/var/www/tts/verbio
install -m $perm_dir $src/www/* $dst/var/www/tts/verbio

# Check for directory existance
if test -d $dst/etc/asterisk ; then
echo "Installing configuration files..."
if test ! -f $dst/etc/asterisk/verbio.conf ; then
install -m $perm_files $src/etc/verbio.conf $dst/etc/asterisk/verbio.conf
else
install -m $perm_files $src/etc/verbio.conf $dst/etc/asterisk/verbio.conf.sample
fi

echo "Installing modules..."
install -m $perm_files $src/modules/*.so $dst/usr/lib/asterisk/modules/
fi

echo "--- Verbio for Asterisk $mversion installation has finished ---"
