#!/bin/sh

mdate=`date +%Y-%m-%d`
mversion=V2-0-1_$mdate

# Where are the asterisk-stat sources
ASTERISK_STAT_SOURCE_TGZ="asterisk-stat-v2_0_1.tar.gz"

# Where is Apache document root directory (if empty, will try to find it)
APACHE_ROOT_DOCUMENT="/var/www"

echo "--- CDR Analyser for Asterisk $mversion Installation ---"

# Copy files

perm_dir=775
perm_files=664
perm_exec=775
perm_all=666
perm_apache=www-data

src=.
dst=
DOCROOT=/var/www/

echo "Creating database cdr ..."
mysql <scripts/create_cdr.sql
if [ $? != 0 ]
then
    echo "*** ERROR: Unable to create cdr database!"
    echo "Installation aborted !"
    exit 1
else
    echo "ok."
fi

echo "Installing Asterisk-Stat Module"
tar --directory=$APACHE_ROOT_DOCUMENT -zxvf tarballs/$ASTERISK_STAT_SOURCE_TGZ 
if [ $? != 0 ]
then
    echo "*** ERROR: Failed to install Asterisk Stat Module !"
    echo "Installation aborted !"
    exit 1
fi
rm -rf $APACHE_ROOT_DOCUMENT/stats
mv $APACHE_ROOT_DOCUMENT/asterisk-stat-v2 $APACHE_ROOT_DOCUMENT/stats
ln -s $APACHE_ROOT_DOCUMENT/stats/cdr.php $APACHE_ROOT_DOCUMENT/stats/index.php

echo "Adding i6net logo..."
cp i6net.gif  $APACHE_ROOT_DOCUMENT/stats/images/asterisk.gif

echo "Configuring Asterisk-Stat..."
cp $src/configs/defines.php $APACHE_ROOT_DOCUMENT/stats/lib/defines.php

echo "Installing Asterisk-Addons Modules..."
install -m $perm_files $src/modules/*.so $dst/usr/lib/asterisk/modules/

echo "Configuring Asterisk-Addons Modules..."
install -m $perm_files $src/configs/cdr_mysql.conf $dst/etc/asterisk/cdr_mysql.conf

echo "--- CDR Analyser for Asterisk $mversion installation has finished ---"

