#!/bin/sh

mversion=V4-2

echo "--- VXIasterisk $mversion Installation ---"

# Copy files

perm_dir=775
perm_files=664
perm_exec=775

src=.
dst=
#src=asterisk_$mversion
#dst=/tmp/asterisk_$mversion

echo "Creating directories..."
mkdir -p $dst/usr/lib/openvxi
mkdir -p $dst/etc/openvxi
mkdir -p $dst/usr/bin
mkdir -p $dst/usr/sbin
mkdir -p $dst/var/lib/openvxi/grammars

echo "Installing binaries..."
install -m $perm_dir $src/bin/openvxi $dst/usr/sbin/
install -m $perm_dir $src/bin/adminvxi $dst/usr/sbin/
install -m $perm_dir $src/bin/safe_openvxi $dst/usr/sbin/

if [ "1" = "1" ]; then \
	if [ -f /etc/redhat-release -o -f /etc/fedora-release ]; then \
		install -m $perm_dir $src/bin/rc.redhat.openvxi /etc/rc.d/init.d/openvxi; \
		/sbin/chkconfig --add openvxi; \
	elif [ -f /etc/debian_version ]; then \
  install -m $perm_dir $src/bin/rc.debian.openvxi /etc/init.d/openvxi; \
		/usr/sbin/update-rc.d openvxi start 9 2 3 4 5 . stop 92 2 3 4 5 .; \
	elif [ -f /etc/gentoo-release ]; then \
		install -m $perm_dir $src/bin/rc.gentoo.openvxi /etc/init.d/openvxi; \
		/sbin/rc-update add openvxi default; \
	elif [ -f /etc/mandrake-release ]; then \
		install -m $perm_dir $src/bin/rc.mandrake.openvxi /etc/rc.d/init.d/openvxi; \
		/sbin/chkconfig --add openvxi; \
	elif [ -f /etc/SuSE-release -o -f /etc/novell-release ]; then \
		install -m $perm_dir $src/bin/rc.debian.openvxi /etc/init.d/openvxi \
		/sbin/chkconfig --add openvxi; \
	elif [ -f /etc/distro-release ]; then \
		install -m $perm_dir $src/bin/rc.distro.openvxi /etc/init.d/openvxi \
		/sbin/chkconfig --add openvxi; \
	elif [ -f /etc/slackware-version ]; then \
		echo "Slackware is not currently supported, although an init script does exist for it." \
	else \
		echo "We could not install init scripts for your distribution."; \
	fi \
else \
	echo "We could not install init scripts for your operating system."; \
fi

echo "Installing configuration files..."
install -m $perm_files $src/etc/defaults.xml $dst/etc/openvxi/defaults.xml.sample
if test ! -f $dst/etc/openvxi/client.cfg ; then
install -m $perm_files $src/etc/VBclient.cfg $dst/etc/openvxi/client.cfg
else
install -m $perm_files $src/etc/VBclient.cfg $dst/etc/openvxi/client.cfg.sample
fi
if test ! -f $dst/etc/asterisk/vxml.conf ; then
install -m $perm_files $src/etc/vxml.conf.sample $dst/etc/asterisk/vxml.conf
else
install -m $perm_files $src/etc/vxml.conf.sample $dst/etc/asterisk/
fi

echo "Installing libraries..."
install -m $perm_files $src/lib/* $dst/usr/lib/openvxi/

echo "Installing modules..."
install -m $perm_files $src/modules/*.so $dst/usr/lib/asterisk/modules/

echo "Installing sounds..."
install -m $perm_files $src/sounds/* $dst/var/lib/asterisk/sounds/

echo "Installing grammars..."
install -m $perm_files $src/grammars/* $dst/var/lib/openvxi/grammars/

echo "--- VXIasterisk $mversion installation has finished ---"

