<?php

error_reporting ( E_ALL );

include_once("config.php");
include_once("ttslib.php");

if(!defined('DEBUG'))
  error_reporting(0);

#default is first in tts array
if(isset($ttsdefault) && array_key_exists($tts[$ttsdefault]) ){
  $ttsname=$ttsdefault;
  debug("Default tts is forced to $ttsname");
}else{
  #default is first in tts array
  $ttsname=array_shift(array_keys($tts));
  debug("Default tts is first in tts array:$ttsname");

}

#Set defaults :
ttssetdefault($tts,$ttsname,$lang,$speaker,$langcode,$iformat,$codec);

debug("Mode debug enabled");

if( getorpost('text',$text)){
  #only text var is a prerequist
  #Override tts default ?
  if( getorpost('ttsname',$newttsname)) 
    if(isset($tts[$newttsname]) ){
      $ttsname=$newttsname;
      #reload defaults
      ttssetdefault($tts,$ttsname,$lang,$speaker,$langcode,$iformat,$codec);
      debug("TTS engine changed to $newttsname");

    }else
      debug("TTS engine not found $newttsname, back to default:$ttsname");


  #Override lang?
  if( getorpost('language',$newlang)){
    #Language tag is correct or we have found a similar tag :
    if(array_key_exists($newlang,$tts[$ttsname]['langcodes']) || trylang($tts[$ttsname]['langcodes'],$newlang) ){
      $lang=$newlang;
      debug("Lang changed to $lang");
      $speaker=$tts[$ttsname]['langcodes'][$lang]['speakers'][0];
      debug("Speaker changed to $speaker");
      $langcode=$tts[$ttsname]['langcodes'][$lang]['code'];
      debug("Langcode changed to $langcode");
    }else{
      debug("Not supported lang : '$newlang', back to default : '$lang'");
      unset($newlang);
    }
  }
    
  #Override gender?
  if( getorpost('gender',$newgender)){
    if(count($tts[$ttsname]['gender'][$newgender])>0){
      foreach( $tts[$ttsname]['gender'][$newgender] as $spktmp){
        #debug("Speaker search for $spktmp");
        if(false !== array_search($spktmp,$tts[$ttsname]['langcodes'][$lang]['speakers'])){
          $speaker=$spktmp;$speakerfound=true;
          debug("Speaker changed to $speaker, it is a $newgender");
          break;
        }
      }
      if(empty($speakerfound))
        debug("No speaker found for '$newgender' gender");
    }else{
      debug("Not supported gender : '$newgender' ");
      unset($newgender);
    }
  }
  #Override default speaker?
  #Caution : VXI use 'voice' for speaker variable
  if( getorpost('speaker',$newspeaker) || getorpost('voice',$newspeaker)){
    if(isset($newgender) && array_search($newspeaker,$tts[$ttsname]['gender'][$newgender])!==false)
      $spkgender=true;
    if(isset($newlang) && array_search($newspeaker,$tts[$ttsname]['langcodes'][$newlang]['speakers'])!==false)
      $spklang=true;

    #get new lang of speaker, also checks if this one exits
    foreach($tts[$ttsname]['langcodes'] as $spklangkey => $spklangvalue )
      if(array_search($newspeaker,$spklangvalue['speakers'])!==false){
        $newspklang=$spklangkey;
        break;
      }
    #debug("spkgender = $spkgender, spklang=$spklang, newspklang=$newspklang, newgender=$newgender,newlang=$newlang");
    #Change only if newgender and newlang are valid with newspeaker, or one or both are not sets.
    if( isset($newgender,$spkgender) || isset($newlang,$spklang) || (isset($newspklang) && is_null($newgender) && is_null($newlang)) ){
      $speaker=$newspeaker;
      $lang=$newspklang;
      debug("Speaker changed to $speaker, Language is now $lang");
    }else{
      debug("Speaker $newspeaker not valid name, or gender, or language keep $speaker");
    }
  }

  #VXI format always : gsm, alaw, wav, ulaw ...
  if(getorpost('format',$newvxiformat)){
    #avoid WAV, wav problems...lowerize input
    $newvxiformat=strtolower($newvxiformat);
    if(array_key_exists($newvxiformat,$tts[$ttsname]['vxiformats']) ){
      $vxiformat=$newvxiformat;
      $codec=$tts[$ttsname]['codecs'][$tts[$ttsname]['vxiformats'][$vxiformat]['codec']];
      $iformat=$tts[$ttsname]['vxiformats'][$vxiformat]['iformat'];
       debug("Internal format changed to $iformat");
       debug("Codec  changed to $codec");
       debug("VXI format is set to $vxiformat"); 
    }else{
      debug("Not supported vxiformat : '$newvxiformat', back to defaults format '$iformat' and codec '$codec'");
    }
  }else{
    #Override internal format?
    #More for test purpose than for real world
    if( getorpost('iformat',$newiformat)){
      if(in_array($newiformat,$tts[$ttsname]['iformats']) ){
        $iformat=$newiformat;
        if($tts[$ttsname]['formatiscodec'])
          $codec=$tts[$ttsname]['codecs'][$format];
        debug("Internal format changed to $iformat");
      }else
        debug("Not supported iformat : '$newiformat', back to default : '$iformat'");
    }

    #Override internal codec?
    #More for test purpose than for real world
    if( getorpost('codec',$newcodec)){
      if(array_key_exists($newcodec,$tts[$ttsname]['codecs'])){
        $codec=$tts[$ttsname]['codecs'][$newcodec];
        debug("Codec changed to $newcodec ($codec)");
        if($tts[$ttsname]['formatiscodec']){
          debug("Format is codec flag setted, so format is $codec");
          $iformat=$codec;
        }


      }else{
        debug("Not supported codec : '$newcodec', back to default : '$codec'");
        debug("Supported codec are: ".implode(", ",array_keys($tts[$ttsname]['codecs'])));
      }
    }
  }



}else
  httperror();

debug("Engine  : $ttsname");
debug("Lang    : $lang");
debug("Speaker : $speaker");
debug("Iformat : $iformat");
debug("Codec   : $codec");

#debug("_SERVER: ".print_r($_SERVER,true));

switch($iformat){
  case 'gif':
    headerdebug("Content-Type: image/gif");
    break;
  case 'ulaw':
  case 'alaw':
  case 'pcm':
  case 'raw':
     headerdebug("Content-Type: audio/raw");
     break;
  case 'wav':
    headerdebug("Content-Type: audio/wav");
    break;
  default:
    headerdebug("Content-Type: application/octet-stream");
}

headerdebug('Content-Disposition: attachment; filename="file.'.$iformat.'"');

$filename=tempnam("/tmp",$ttsname."TMP");
$file=fopen($filename, "w");

debug(" Temp file = $filename");

#Some TTS only support special charset, default is UTF8.
if(function_exists('mb_convert_encoding')){
  #UTF8 must always be tested first... 
  mb_detect_order('UTF-8,'.implode(',',$tts[$ttsname]['charsets']));
  debug("Detect order: ".print_r(mb_detect_order(),true));
  $currentcharset=mb_detect_encoding($text);
  debug("Current charset : $currentcharset");
  if(array_search($currentcharset,$tts[$ttsname]['charsets']) === false ){
    debug("Current charset not supported, convert to ".$tts[$ttsname]['charsets'][0]);
    fwrite($file, mb_convert_encoding( stripslashes($text),$tts[$ttsname]['charsets'][0], 'auto'));
  }else{
    debug("No need to convert");
    fwrite($file, stripslashes($text));
  }
}else{
  debug("function mb_convert_encoding not found, no charset correction");
  fwrite($file, stripslashes($text));
}

if(defined('DEBUG')){
  debug("TEXT: '".print_r(file($filename),true)."'");
  debug("TEXT BIN: '".bin2hex(implode('',file($filename)))."'");
  debug("FILE ANALYSE: '".print_r(execdebug("file $filename"),true));
}

register_shutdown_function('cleanup',"$filename");
fwrite($file, "\n");
fclose($file);

$time_start = microtime(true);
register_shutdown_function('cleanup',"$filename.$iformat");


$arguments='';
foreach( $tts[$ttsname]['args'] as $key => &$argument){
  eval('$tmp="ARG$key: \'$argument\'"; $evalargument="'.$argument.'";');
  debug("$tmp -> $evalargument");
  $arguments .= ' '.$evalargument;
}
if(defined('DEBUG')){
  $arguments .= ' '.$tts[$ttsname]['debugargs'].' 2>&1';
  debug("Added debug arguments : '".$tts[$ttsname]['debugargs']."  2>&1'");
}
$execline=$tts[$ttsname]['program'].$arguments;
execdebug($execline,$return, $status);
$time_end = microtime(true);
$texec = $time_end - $time_start;
$outsize=filesize("$filename.$iformat");

debug(" STATUS: $status");

if(!defined('DEBUG'))
  readfile("$filename.$iformat");
else{
  debug(" File size = $outsize");
}
if($enable_record_to_cdr)
  register_shutdown_function('cdrrecord',$ttsname,$lang,$status,$texec,$text,$outsize);

register_shutdown_function('garbage',$ttsname);

// vim: set filetype=php expandtab tabstop=2 shiftwidth=2 autoindent smartindent:
?>
