<?php
// vim: set filetype=php expandtab tabstop=2 shiftwidth=2 autoindent smartindent:

error_reporting ( E_ALL );

include("config.php");
include("ttslib.php");

if(getorpost('debug',$debug)){
  if(!defined('DEBUG'))
    define("DEBUG", true );
  include("tts.php");
}else{
  #No debug
  include("tts.php");
  exit();
}

debug("FILENAME: $filename.$iformat");
execdebug("file \"$filename.$iformat\"  2>&1",$tmpout,$tmpstatus);

debug('Context : '.$context=implode('_',array($ttsname,$iformat,$codec)));

#Check ffmpeg if present on local, add directory
$ffmpegdir="/usr/local/bin/";
if(! file_exists($ffmpegdir."ffmpeg")){
  $ffmpegdir="";
}else{
  debug("ffmpeg called from $ffmpegdir");
}


#Common command line end
$fileend=" $filename.$iformat ${filename}ffmpeg.wav 2>$filename.err.ffmpeg ";
register_shutdown_function('cleanup',"${filename}ffmpeg.wav");
register_shutdown_function('cleanup',"$filename.err.ffmpeg");

switch($context){
  case 'acapela_raw_8k':
  case 'loquendo_raw_l':
  case 'loquendo_raw_linear':
  case 'verbio_pcm_LIN16':
    debug('Special: raw 8KHz linear 16 bits');
    execdebug($ffmpegdir."ffmpeg -acodec pcm_s16le -ar 8000 -ac 1 -f s16le -i ".$fileend,$tmpout,$tmpstatus);
   break;
  
  case 'acapela_raw_8ka':   
  case 'verbio_alaw_ALAW':
  case 'loquendo_raw_a':
    debug('Special: raw 8KHz A-LAW 8 bits');
    execdebug($ffmpegdir."ffmpeg -acodec pcm_alaw -ar 8000 -ac 1 -f alaw -i ".$fileend,$tmpout,$tmpstatus);
    break;
  case 'acapela_raw_8kmu':
  case 'loquendo_raw_u':
  case 'verbio_ulaw_ULAW':
    debug('Special: raw 8KHz &micro;-LAW 8 bits');
    execdebug($ffmpegdir."ffmpeg -acodec pcm_mulaw -ar 8000 -ac 1 -f mulaw -i ".$fileend,$tmpout,$tmpstatus);
    break;
  default:
    #check wav ... anyway
    execdebug($ffmpegdir."ffmpeg -i ".$fileend,$tmpout,$tmpstatus);
}
debug("FFMPEG STDERR:".print_r(file("$filename.err.ffmpeg",FILE_IGNORE_NEW_LINES),true));

execdebug($ffmpegdir."ffmpeg -i ${filename}ffmpeg.wav -ar 44100 $filename.mp3 2>$filename.err.ffmpeg",$tmpout,$tmpstatus);
debug("LAME STDERR:".print_r(file("$filename.err.ffmpeg",FILE_IGNORE_NEW_LINES),true));


#Garbage more ofen (80%), mp3 are not cleaned   by default
register_shutdown_function('garbage',$ttsname,90);


?>
<script type="text/javascript">
<!--
  parent.ttsplayer.location.href = "tts-player.php?filename=<?echo basename($filename)?>"
//-->
</script>


