#!/bin/bash

mversion=2.0
TTSENGINE=loquendo

echo "--- $TTSENGINE HTTP/TTS $mversion Installation ---"

# Copy files

perm_dir=775
perm_files=664
perm_exec=775

src=.
dst=

#Check SELinux enabled ?
sestatus -b 2>/dev/null | grep -q enabled
if test "$?" = "0" ; then
       echo "SELinux is enabled: this install won't work"
       echo "Please disable it before install..."
       exit
fi

#Check Loquendo Version
if [ -d /opt/Loquendo/LTTS7 ];then
  lttsver=7
  ltts=/opt/Loquendo/LTTS7
elif [ -d /opt/LTTS  ];then
  lttsver=6
  ltts=/opt/LTTS
else
  echo "Loquendo not found !"
  exit 1
fi
echo "Using Loquendo $ltts..."
 

echo "Installing Web script..."
wwwdirselect=/var/www
echo $n "Enter apache web root directory[$wwwdirselect]: $c"
read wwwdiruser
if [ -n "$wwwdiruser" ]; then
	wwwdirselect=$wwwdiruser
fi
echo "Selected www dir : $wwwdirselect"

mkdir -p $dst/$wwwdirselect/tts/$TTSENGINE
install -m $perm_files $src/www/* $dst/$wwwdirselect/tts/$TTSENGINE
mv -v $dst/$wwwdirselect/tts/$TTSENGINE/config${lttsver}.php $dst/$wwwdirselect/tts/$TTSENGINE/config.php
rm -rvf $dst/$wwwdirselect/tts/$TTSENGINE/config?.php

[ -f $ltts/bin/TTSFileGenerator ] && mv $ltts/bin/TTSFileGenerator $ltts/bin/TTSFileGenerator.old

ARCH=`uname -m`
if [ "$ARCH" = "x86_64" ] ; then  
	echo "Installing x86_64  binaries..."
	install -m $perm_exec $src/bin/TTSFileGenerator${lttsver}_64 $ltts/bin/TTSFileGenerator
else
	echo "Installing i386 binaries..."
	install -m $perm_exec $src/bin/TTSFileGenerator${lttsver} $ltts/bin/TTSFileGenerator
fi

echo "--- $TTSENGINE HTTP/TTS $mversion installation has finished ---"

