#!/bin/bash

mversion=V8.02

src=.

#Check SELinux enabled ?
sestatus -b 2>/dev/null | grep -q enabled
if test "$?" = "0" ; then
       echo "SELinux is enabled: this install won't work"
       echo "Please disable it before install..."
       exit
fi

#Found Asterisk
which -a asterisk 2>&1 >/dev/null
if [ ! "$?" = "0" ];then
  echo "Asterisk binary not found in PATH:$PATH"
  exit 1
fi

#Check Asterisk Version
asteriskversion=`asterisk -V| cut -d ' ' -f 2` 
case "$asteriskversion" in
  1.4.*)
    astflavour="1.4";;
  1.6.0.*)
    astflavour="1.6.0";;
  1.6.1.*)
    astflavour="1.6.1";;
  1.6.2.*)
    astflavour="1.6.2";;
  *)
    echo "Unknow Asterisk Version: '$asteriskversion', exiting"
    exit 1;;
esac
ls $src/modules/res_speech_verbio.so.asterisk_v$astflavour* 2> /dev/null
if [ ! -f  $src/modules/res_speech_verbio.so.asterisk_v$astflavour* ];then
  echo "No modules for this asterisk Version: '$astflavour', exiting"
  exit 1
fi

echo "Asterisk $asteriskversion installed."

#Check Asterisk Directory
asteriskdir=usr/lib/asterisk
if [ ! -d  $dst/$asteriskdir ];then
  echo -n "Asterisk directory not found (/$asteriskdir), please enter one:"
  read asteriskdiruser
  [ ! -d $dst/$asteriskdiruser ] && echo "$dst/$asteriskdiruser not found." && exit 1
  sed -e s_asteriskdir=.*_asteriskdir=${asteriskdiruser}_ uninstall.sh > uninstall.sh2 &&  mv uninstall.sh2 uninstall.sh
  asteriskdir=$asteriskdiruser
fi

echo "--- Verbio ASR for Asterisk Installation ---"
echo "--- Verbio Clients Version is 8.02 ---"
echo "--- Verbio ASR (res_speech) Version is 3.4 ---" 

# Copy files

perm_dir=775
perm_files=664
perm_exec=775

src=.
dst=
#src=asterisk_$mversion
#dst=/tmp/asterisk_$mversion

echo "Creating directories..."
mkdir -p $dst/var/lib/asterisk/verbio/text
mkdir -p $dst/var/lib/asterisk/verbio/gram
mkdir -p $dst/var/lib/asterisk/verbio/audio

# Check for directory existance
if test -d $dst/etc/asterisk ; then
echo "Installing configuration files..."
if test ! -f $dst/etc/asterisk/verbio.conf ; then
install -m $perm_files $src/etc/verbio.conf $dst/etc/asterisk/verbio.conf
else
install -m $perm_files $src/etc/verbio.conf $dst/etc/asterisk/verbio.conf.sample
fi

echo "Installing modules..."
install -m $perm_files $src/modules/res_speech_verbio.so.asterisk_v${astflavour}* $dst/$asteriskdir/modules/res_speech_verbio.so
fi

echo "--- Verbio for Asterisk installation has finished ---"
