<?php

/**
 * config actions.
 *
 * @package    psms
 * @subpackage config
 * @author     Your name here
 * @version    SVN: $Id: actions.class.php,v 1.1 2010-02-12 16:18:49 javier.sixto Exp $
 */
class configActions extends sfActions
{
  protected $dialer='/opt/dialer/dialer';
  protected static $campaign='default';
  
  public function readDialerConf(){
    $params=array();
    foreach( explode("\n",file_get_contents('/etc/dialer.conf')) as $value ){
      //$this->params(
      switch(substr($value,0,1)){
        case ';':
        case '':
          continue;
        case '[':
          $section=trim(str_replace(array('[',']'),'',$value));
          continue;
        default:
          $equal=strpos($value,'=');
          $params[$section][trim(substr($value,0,$equal))]=trim(substr($value,$equal+1));
        }
    }
    return $params;
  }
  
  public function writeDialerConf($params){
    //var_dump($params);
    $newfile='';
    foreach( $params as $sec_name => $section ){
     //var_dump($sec_name); 
      if(is_array($section)){
        $newfile.="[$sec_name]\n";
        foreach( $section as $key => $value )
          if($value) $newfile.="$key=$value\n";
        $newfile.="\n";
      }
    }
    file_put_contents('/etc/dialer.conf', $newfile);
    $this->getUser()->setFlash('informations', 'Dialer config file changed');
  }

 /**
  * Executes index action
  *
  * @param sfRequest $request A request object
  */
  public function executeIndex(sfWebRequest $request)
  {
    // always read first
    $this->getUser()->setAttribute('dialer_config', $dialer_config=$this->readDialerConf(),null);
    //var_dump($dialer_config);
    $this->form = new DialerConfForm(array(
      'maxlines'=>$dialer_config[self::$campaign]['maxlines'],
      'retry'=>$dialer_config[self::$campaign]['attempts']-1,
      'timeout'=>$dialer_config[self::$campaign]['timeout'],
      'mode'=>$dialer_config[self::$campaign]['mode'],
      'callerid'=>$dialer_config[self::$campaign]['callerid'],
      'dialformat'=>$dialer_config[self::$campaign]['dialformat'],
    ));

    if ($request->isMethod('post')){
      $this->form->bind($request->getParameter('dialconf') );

      //Return button
      if($request->getParameter('cancel',null))
        $this->redirect('main/index');

      if ($this->form->isValid()){
        $values = $this->form->getValues();
        //var_dump($_POST);exit;
        $dialer_config[self::$campaign]['maxlines']=$values['maxlines'];
        $dialer_config[self::$campaign]['attempts']=$values['retry']+1;
        $dialer_config[self::$campaign]['timeout']=$values['timeout'];
        $dialer_config[self::$campaign]['mode']=$values['mode'];
        $dialer_config[self::$campaign]['callerid']=$values['callerid'];
        $dialer_config[self::$campaign]['dialformat']=$values['dialformat'];
        $this->writeDialerConf($dialer_config);
        $this->getUser()->getAttributeHolder()->remove('dialer_config');
        $this->redirect('config/index');
        
      }
    }
  }
}
