<?php

require_once(sfConfig::get('sf_lib_dir').'/filter/doctrine/BaseFormFilterDoctrine.class.php');

/**
 * Phone filter form base class.
 *
 * @package    filters
 * @subpackage Phone *
 * @version    SVN: $Id: BasePhoneFormFilter.class.php,v 1.1 2010-02-12 16:18:49 javier.sixto Exp $
 */
class BasePhoneFormFilter extends BaseFormFilterDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'phone'          => new sfWidgetFormFilterInput(),
      'seconds'        => new sfWidgetFormFilterInput(),
      'attempts'       => new sfWidgetFormFilterInput(),
      'pickups'        => new sfWidgetFormFilterInput(),
      'detail'         => new sfWidgetFormFilterInput(),
      'user_id'        => new sfWidgetFormDoctrineChoice(array('model' => 'sfGuardUser', 'add_empty' => true)),
      'created_at'     => new sfWidgetFormFilterDate(array('from_date' => new sfWidgetFormDate(), 'to_date' => new sfWidgetFormDate(), 'with_empty' => true)),
      'updated_at'     => new sfWidgetFormFilterDate(array('from_date' => new sfWidgetFormDate(), 'to_date' => new sfWidgetFormDate(), 'with_empty' => true)),
      'campaigns_list' => new sfWidgetFormDoctrineChoiceMany(array('model' => 'Campaign')),
    ));

    $this->setValidators(array(
      'phone'          => new sfValidatorPass(array('required' => false)),
      'seconds'        => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'attempts'       => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'pickups'        => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'detail'         => new sfValidatorPass(array('required' => false)),
      'user_id'        => new sfValidatorDoctrineChoice(array('required' => false, 'model' => 'sfGuardUser', 'column' => 'id')),
      'created_at'     => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDate(array('required' => false)), 'to_date' => new sfValidatorDate(array('required' => false)))),
      'updated_at'     => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDate(array('required' => false)), 'to_date' => new sfValidatorDate(array('required' => false)))),
      'campaigns_list' => new sfValidatorDoctrineChoiceMany(array('model' => 'Campaign', 'required' => false)),
    ));

    $this->widgetSchema->setNameFormat('phone_filters[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function addCampaignsListColumnQuery(Doctrine_Query $query, $field, $values)
  {
    if (!is_array($values))
    {
      $values = array($values);
    }

    if (!count($values))
    {
      return;
    }

    $query->leftJoin('r.CampaignPhone CampaignPhone')
          ->andWhereIn('CampaignPhone.campaign_id', $values);
  }

  public function getModelName()
  {
    return 'Phone';
  }

  public function getFields()
  {
    return array(
      'id'             => 'Number',
      'phone'          => 'Text',
      'seconds'        => 'Number',
      'attempts'       => 'Number',
      'pickups'        => 'Number',
      'detail'         => 'Text',
      'user_id'        => 'ForeignKey',
      'created_at'     => 'Date',
      'updated_at'     => 'Date',
      'campaigns_list' => 'ManyKey',
    );
  }
}