<?php

/**
 * SfGuardUserProfile form base class.
 *
 * @package    form
 * @subpackage sf_guard_user_profile
 * @version    SVN: $Id: BaseSfGuardUserProfileForm.class.php,v 1.1 2010-02-12 16:18:49 javier.sixto Exp $
 */
class BaseSfGuardUserProfileForm extends BaseFormDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'user_id'    => new sfWidgetFormInputHidden(),
      'first_name' => new sfWidgetFormInput(),
      'last_name'  => new sfWidgetFormInput(),
      'email'      => new sfWidgetFormInput(),
      'created_at' => new sfWidgetFormDateTime(),
      'updated_at' => new sfWidgetFormDateTime(),
    ));

    $this->setValidators(array(
      'user_id'    => new sfValidatorDoctrineChoice(array('model' => 'SfGuardUserProfile', 'column' => 'user_id', 'required' => false)),
      'first_name' => new sfValidatorString(array('max_length' => 128, 'required' => false)),
      'last_name'  => new sfValidatorString(array('max_length' => 128, 'required' => false)),
      'email'      => new sfValidatorString(array('max_length' => 128, 'required' => false)),
      'created_at' => new sfValidatorDateTime(array('required' => false)),
      'updated_at' => new sfValidatorDateTime(array('required' => false)),
    ));

    $this->widgetSchema->setNameFormat('sf_guard_user_profile[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'SfGuardUserProfile';
  }

}
