#!/bin/bash
#set -vx
mversion="V0.1"
SYMFONY="1.2.10"
echo "--- Asterisk Dialer Installation ---"

# Copy files

perm_dir=775
perm_files=664
perm_exec=775


src=.
dst=

echo "Install Mysql, Apache2 and php5"
aptitude update
aptitude install mysql-server php5 php5-cli php5-xsl php5-mysql php-apc apache2
a2enmod rewrite
/etc/init.d/apache2 restart

echo "Creating directories..."
mkdir -p $dst/opt/dialer

echo "Installing Dialer binary..."
install -m $perm_exec $src/bin/dialer $dst/opt/dialer/

echo "Installing dialer config..."
install -m 666 $src/conf/dialer.conf $dst/etc/dialer.conf

echo "Installing Symfony Framework..."
tar -zxf symfony-${SYMFONY}.tgz  -C /opt

echo "Creating Mysql users and bases ..."
echo "Please enter mysql root password or press 'Return', if it's not setted :"
mysql -p  <scripts/init.sql
if [ $? != 0 ]
then
    echo "*** ERROR: init databases"
    echo "Installation aborted !"
    exit 1
else
    echo "ok."
fi

echo "Installing Web Panel..."
wwwdirselect=/var/www
echo $n "Enter apache web root directory[$wwwdirselect]: $c"
read wwwdiruser
if [ -n "$wwwdiruser" ]; then
	wwwdirselect=$wwwdiruser
fi
echo "Selected www dir : $wwwdirselect"
if [ -d $wwwdirselect ];then
  #Copy and configure web panel
  cp -rp $src/dialer-web-panel/* /opt/dialer
  mkdir -pv /opt/dialer/lib/vendor
  ln -vsT /opt/symfony-${SYMFONY} /opt/dialer/lib/vendor/symfony
  ln -vsT /opt/dialer/web ${wwwdirselect}/dialer
  ln -vsT /opt/dialer/lib/vendor/symfony/data/web/sf /opt/dialer/web/sf
  ln -vsT /opt/dialer/lib/vendor/symfony/lib/plugins/sfDoctrinePlugin/web /opt/dialer/web/sfDoctrinePlugin
  chmod +x /opt/dialer/symfony
  for pubdir in /opt/dialer/log /opt/dialer/cache /opt/dialer/web/upload; do
    mkdir -vp $pubdir
    chmod 777 $pubdir
  done
  /opt/dialer/symfony --version
  if [ "$0" = "0" ]; then
    echo "Enable to start symfony..."
    exit 1
  fi
  echo "Init Symfony Database"
  /opt/dialer/symfony doctrine-build-all-reload --no-confirmation
  username="customer"
  echo $n "Please enter a username to connect to web interface [$username]: "
  read customersel
  if [ -n "$customersel" ];then
    username=$customersel
  fi
  echo "Please enter password for username '$username'"
  read -s custpassword
  /opt/dialer/symfony guard:create-user $username $custpassword

else
  echo "Selected www dir not found: $wwwdirselect !"
  exit
fi


echo "--- Asterisk Dialer $mversion installation has finished ---"

