<?php

/**
 * main actions.
 *
 * @package    psms
 * @subpackage main
 * @author     Your name here
 * @version    SVN: $Id: actions.class.php,v 1.1 2010-02-12 16:18:49 javier.sixto Exp $
 */

class mainActions extends sfActions
{
  protected $dialer='/opt/dialer/dialer';
  protected static $campaign='default';
  
  public function getUserId(){
    //From session created by sfGuard only
    return $this->getUser()->getAttribute('user_id',null,'sfGuardSecurityUser');
  }

  public function readDialerConf(){
    $params=array();
    foreach( explode("\n",file_get_contents('/etc/dialer.conf')) as $value ){
      //$this->params(
      switch(substr($value,0,1)){
        case ';':
        case '':
          continue;
        case '[':
          $section=trim(str_replace(array('[',']'),'',$value));
          continue;
        default:
          $equal=strpos($value,'=');
          $params[$section][trim(substr($value,0,$equal))]=trim(substr($value,$equal+1));
        }
    }
    $this->getUser()->setFlash('informations', 'Dialer config file read');
    return $params;
  }

  public function executeIndex(sfWebRequest $request)
  {
    $this->campaign=self::$campaign;
    if(!$this->getUser()->getAttribute('dialer_config')){
      $this->getUser()->setAttribute('dialer_config', $this->readDialerConf());
    }
    $this->dialer_config=$diale=$this->getUser()->getAttribute('dialer_config');
    @$this->dialerpid= file_get_contents('/tmp/dialer.lock');

    //Read stats
    exec($this->dialer.' -a statistics -c '.$this->campaign,$brutstats,$statret);
    foreach($brutstats as $line){
      $tmp=explode(':',$line);
      $stats[trim($tmp[0])]=trim($tmp[1]);
    }
    $this->progress= round(($stats['Attempts']/$stats['Count'])*100);
    $this->attempts=$stats['Attempts'];
    $this->todo=$stats['Todo'];
    $this->count=$stats['Count'];


    exec("/bin/ps ".$this->dialerpid,$t,$result);
    if($result==0 && $this->dialerpid ){
      $this->status='running';
    }else
      $this->status='stopped';
    $this->getUser()->setAttribute('dialer_status',$this->status);

   $this->fileform = new DialerFileForm(null,$this->getUserId());
    if($request->isMethod('post')){
      //var_dump($request->getParameter($this->fileform->getName()));
      //echo "name:".$this->fileform->getName();
      $this->fileform->bind($request->getParameter($this->fileform->getName()),$request->getFiles($this->fileform->getName()));
      if ($this->fileform->isValid()){
        $this->getUser()->setFlash('informations', 'Processing file ...');
        $this->fileform->getValue('file')->getTempName();
        exec($this->dialer.' --stop');
        exec($this->dialer.' -a drop '.$this->campaign);
        exec($this->dialer.' -a create '.$this->campaign);
        exec($this->dialer.' -a file -c '.$this->campaign.' -p '.$this->fileform->getValue('file')->getTempName());
        $this->getUser()->setFlash('informations', 'Campaign '.$this->campaign.' loaded');
        $this->redirect('main/index');
      }
    }else{
      switch($request->getParameter('cmd')){
        case 'start':
                      #$this->getUser()->setFlash('informations', 'Starting dialer...');
                      shell_exec('/usr/bin/nohup '.$this->dialer.' --start  >/dev/null &');
                      sleep(1);
                      $this->redirect('main/index'); 
                      break;
        case 'stop':
                      #$this->getUser()->setFlash('informations', 'Stopping dialer...');
                      shell_exec('/usr/bin/nohup '.$this->dialer.' --stop >/dev/null &');
                      sleep(1);
                      $this->redirect('main/index');
                      break;
        case 'dwlog':
                      $this->redirect('main/dwlog');
                      break;


      };
    }
  }

  public function executeDwlog(sfWebRequest $request)
  {
    $this->campaign='default';
    header("Content-type: application/octet-stream");
    header("Content-Disposition: attachment; filename=\"".$this->campaign.".csv\"");
    passthru($this->dialer.' -a fulldump -c '.$this->campaign);
    exit;
  }
}
