<?php
class DialerConfForm extends sfForm
{
  protected static $retries = array(0,1,2,3,4,5);
  protected static $timeouts = array(0=>"none",1000=>"1s",5000=>"5s",10000=>"10s",15000=>"15s",20000=>"20s",25000=>"25s",30000=>"30s",40000=>"40s",60000=>"1mn");
  protected static $modes = array("vxml"=>"vxml", "video"=>"video", "dialplan"=>"dialplan");


  public function readAstConf($section,$name,$filename){
    if(!is_readable($filename))
      return null;
    $params=array();
    foreach( explode("\n",file_get_contents($filename)) as $value ){
      //$this->params(
      switch(substr($value,0,1)){
        case ';':
        case '':
          continue;
        case '[':
          $sectionname=trim(str_replace(array('[',']'),'',$value));
          continue;
        default:
          $equal=strpos($value,'=');
          $params[$sectionname][trim(substr($value,0,$equal))]=trim(substr($value,$equal+1));
        }
    }
    //var_dump($params);
    //echo "<br> section:'$section' name:'$name' value:'$params[$section][$name]'";
    if(isset($params[$section][$name]))
      return $params[$section][$name];
    else
      return null;
  }

  public function configure()
  {
    $this->setWidgets(array(
      'maxlines' => new sfWidgetFormInput(),
      'retry'    => new sfWidgetFormChoice(array(
                    'choices'  => self::$retries)),
    'timeout'   => new sfWidgetFormChoice(array(
                    'choices'  => self::$timeouts)),
    'mode'   => new sfWidgetFormChoice(array(
                    'choices'  => self::$modes)),
      'callerid'   => new sfWidgetFormInput(),
      'dialformat' => new sfWidgetFormInput(),
    ));

    //limit max maxlines to max vxml licenses :
    $max_maxlines=$this->readAstConf('license','max','/etc/asterisk/vxml.conf');
    if( ! $max_maxlines )
      $max_maxlines=1;

    $this->setValidators(array(
      'maxlines' => new sfValidatorInteger(array('required' => true, 'min'=>1, 'max'=> $max_maxlines)),
      'retry'     => new sfValidatorChoice(array('choices' => array_keys(self::$retries))),
      
      'timeout'    => new sfValidatorChoice(array('choices' => array_keys(self::$timeouts))),
      'mode'     => new sfValidatorChoice(array('choices' => array_keys(self::$modes))),
      'callerid'      => new sfValidatorString(array('required' => true)),
      'dialformat'      => new sfValidatorString(array('required' => true)),
    ));


    $this->widgetSchema->setNameFormat('dialconf[%s]');
  
  }
}

?>
