<?php

/**
 * sfGuardUserProfile form base class.
 *
 * @package    form
 * @subpackage sf_guard_user_profile
 * @version    SVN: $Id: BasesfGuardUserProfileForm.class.php,v 1.2 2010-02-12 23:36:38 javier.sixto Exp $
 */
class BasesfGuardUserProfileForm extends BaseFormDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'id'          => new sfWidgetFormInputHidden(),
      'user_id'     => new sfWidgetFormDoctrineChoice(array('model' => 'sfGuardUser', 'add_empty' => false)),
      'first_name'  => new sfWidgetFormInput(),
      'last_name'   => new sfWidgetFormInput(),
      'email'       => new sfWidgetFormInput(),
      'expiry_date' => new sfWidgetFormDate(),
      'created_at'  => new sfWidgetFormDateTime(),
      'updated_at'  => new sfWidgetFormDateTime(),
    ));

    $this->setValidators(array(
      'id'          => new sfValidatorDoctrineChoice(array('model' => 'sfGuardUserProfile', 'column' => 'id', 'required' => false)),
      'user_id'     => new sfValidatorDoctrineChoice(array('model' => 'sfGuardUser')),
      'first_name'  => new sfValidatorString(array('max_length' => 128, 'required' => false)),
      'last_name'   => new sfValidatorString(array('max_length' => 128, 'required' => false)),
      'email'       => new sfValidatorString(array('max_length' => 128, 'required' => false)),
      'expiry_date' => new sfValidatorDate(array('required' => false)),
      'created_at'  => new sfValidatorDateTime(array('required' => false)),
      'updated_at'  => new sfValidatorDateTime(array('required' => false)),
    ));

    $this->validatorSchema->setPostValidator(
      new sfValidatorDoctrineUnique(array('model' => 'sfGuardUserProfile', 'column' => array('user_id')))
    );

    $this->widgetSchema->setNameFormat('sf_guard_user_profile[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'sfGuardUserProfile';
  }

}
