#!/bin/sh
# vim: set expandtab tabstop=4 shiftwidth=4 autoindent smartindent: 
mdate=`date +%Y-%m-%d`

# Where is Apache document root directory (if empty, will try to find it)
APACHE_ROOT_DOCUMENT="/var/www"

echo "--- CDR Analyser for Asterisk Installation ---"

# Copy files

perm_dir=775
perm_files=664
perm_exec=775
perm_all=666
perm_apache=www-data

src=.
dst=
DOCROOT=/var/www/

echo "Creating database cdr ..."
echo "Please enter mysql root password or press 'Return', if it's not setted :"
mysql -p  <scripts/create_cdr.sql
if [ $? != 0 ]
then
    echo "*** ERROR: Unable to create cdr database!"
    echo "Installation aborted !"
    exit 1
else
    echo "ok."
fi

echo "Installing Asterisk-Stat Module"
rm -rf $APACHE_ROOT_DOCUMENT/stats
cp -rp stats $APACHE_ROOT_DOCUMENT

echo "Configuring Asterisk-Addons Modules..."
install -m $perm_files $src/configs/cdr_mysql.conf $dst/etc/asterisk/cdr_mysql.conf

echo "Configuring Apache htpasswd..."
for apachedir in /etc/httpd /etc/apache2 /etc/apache;do
    if [ -d $apachedir ];then
        apachedirselect=$apachedir
    fi
done
echo $n "Enter apache web root directory[$apachedirselect]: $c"
read apachediruser
if [ -n "$apachediruser" ]; then
	apachedirselect=$apachediruser
fi
echo "Selected root dir : $apachedirselect"
if [ -d $apachedirselect ];then
    if [ -d $apachedirselect/conf.d ];then
        cp -v scripts/stats-cdr-apache.conf $apachedirselect/conf.d/cdr-stats.conf
        httpusername="customer"
        echo $n "Please enter a username to connect to web interface [$httpusername]: $c"
        read customersel
        if [ -n "$customersel" ];then
            httpusername=$customersel
        fi
        if [ ! -e $apachedirselect/htpasswd ];then
            createit="-c"
        fi
        echo "Please enter password for username '$httpusername'"
        # Use MD5, better than default DES (limit passwd to  8chars)
        htpasswd -m $createit $apachedirselect/htpasswd $httpusername
        if [ $? = "0" ];then
            echo "You must restart apache ..."
        else
            echo "An error as occured during htpasswd call"
        fi
    else
        echo "No conf.d directory, unable ton continue"
    fi
else
    echo "Selected root dir not found!"
fi

