#!/bin/bash

mversion=V1.4

echo "--- Video for Asterisk $mversion Installation ---"

src=.
dst=

if [ -n $1 ]; then
  dst=$1
  echo "dst=$dst"
fi

#Check SELinux enabled ?
sestatus -b 2>/dev/null | grep -q enabled
if test "$?" = "0" ; then
       echo "SELinux is enabled: this install won't work"
       echo "Please disable it before install..."
       exit
fi

#Found Asterisk
which -a asterisk 2>&1 >/dev/null
if [ ! "$?" = "0" ];then
  echo "Asterisk binary not found in PATH:$PATH"
  exit 1
fi

#Check Asterisk Version
asteriskversion=`asterisk -V| cut -d ' ' -f 2` 
case "$asteriskversion" in
  1.4.*)
    astflavour="1.4";;
  1.6.2.*)
    astflavour="1.6.2";;
  *)
    echo "Unknow Asterisk Version: '$asteriskversion', exiting"
    exit 1;;
esac

#CPT=`ls $src/modules/*.so*$astflavour*| wc -l `
#if [ "$CPT" != "10" ];then
#  echo "No modules or missing for this asterisk Version: '$astflavour', exiting"
#  exit 1
#fi

echo "Asterisk $asteriskversion installed."

#Check Asterisk Modules Directory
modulesdir=usr/lib/asterisk/modules
if [ ! -d  $dst/$modulesdir ];then
  echo -n "Asterisk modules dir not found (/$modulesdir), please enter one:"
  read modulesdiruser
  [ ! -d $dst/$modulesdiruser ] && echo "$dst/$modulesdiruser not found." && exit 1
  sed -e s_modulesdir=.*_modulesdir=${modulesdiruser}_ uninstall.sh > uninstall.sh2 &&  mv uninstall.sh2 uninstall.sh
  modulesdir=$modulesdiruser
fi

# Copy files

perm_dir=775
perm_files=664
perm_exec=775

# Files selection

CFG=""

USR="h324m.conf \
     ooh323.conf \
     rtmp.conf"
     
echo "Creating directories..."
mkdir -p $dst/usr/lib/asteriskvideo
#mkdir -p $dst/etc/h324m

echo "Installing libraries..."
install -m $perm_files $src/lib/* $dst/usr/lib/asteriskvideo/

for modname in \
  app_mp4 \
  app_h324m \
  app_transcoder \
  app_recorder \
  app_rtsp \
  app_waitforvideo \
  app_camera \
  app_konference \
  chan_ooh323 \
  format_h263p \
  chan_rtmp ; do
  echo "Installing modules $modname..."
  install -m $perm_files $src/modules/$modname.so.asterisk_v$astflavour*  $dst/$modulesdir/$modname.so
done

echo "Installing configuration files..."
for x in $CFG; do 
 install -m $perm_files $src/configs/$x $dst/etc/asterisk/$x
done  
for x in $USR; do 
 if test ! -f "$dst/etc/asterisk/$x" ; then
 #echo "File $x updated."
 install -m $perm_files $src/configs/$x $dst/etc/asterisk/$x
 else
 #echo "File $x skipped, $x.sample installed."
 install -m $perm_files $src/configs/$x $dst/etc/asterisk/$x.sample
 fi
done 

echo "--- Video for Asterisk $mversion installation has finished ---"

