#!/bin/bash

mversion="V3.01h"
TTSENGINE=mbrola

echo "--- $TTSENGINE TTS $mversion Installation ---"

# Copy files

perm_dir=775
perm_files=664
perm_exec=775

src=.
dst=

#part1
echo -n "Checking mbrola binary is working here:"
if [ ! ./bin/mbrola ]; then
  echo " mbrola binary seems to do not work, if you are running on x64 linux, please install lib32 libc"
  exit  1
else
  echo " Ok."
fi

# mbrola needs espeak and ffmpeg to works as TTS.
for bin in espeak ffmpeg;do
  echo -n "Checking $bin binary :"
  if [ ! -f /usr/local/bin/$bin ];then
    echo "mbrola need $bin package"
    exit 1
  else
    echo " Ok."
  fi 
done

echo "Creating directories..."
mkdir -p $dst/usr/local/bin
mkdir -p $dst/usr/local/share/mbrola/en1

echo "Installing binary and voice (en1) ..."
install -m $perm_exec $src/bin/mbrola $dst/usr/local/bin/
install -m $perm_files $src/voices/en1/* $dst/usr/local/share/mbrola/en1/


#part2
echo "Installing Web script..."
wwwdirselect=/var/www
echo $n "Enter apache web root directory[$wwwdirselect]: $c"
read wwwdiruser
if [ -n "$wwwdiruser" ]; then
	wwwdirselect=$wwwdiruser
fi
echo "Selected www dir : $wwwdirselect"

mkdir -p $dst/$wwwdirselect/tts/$TTSENGINE
install -m $perm_files $src/www/* $dst/$wwwdirselect/tts/$TTSENGINE

mkdir -p $dst/$wwwdirselect/tts/$TTSENGINE/html5media
install -m $perm_files $src/html5media/* $dst/$wwwdirselect/tts/$TTSENGINE/html5media/


echo "--- $TTSENGINE HTTP/TTS $mversion installation has finished ---"
