#!/bin/bash
mversion=4.0
TTSENGINE=loquendo

echo "--- $TTSENGINE HTTP/TTS $mversion Installation  ---"
echo "--- For Loquendo 6, 7 and 7.1  ---"

# Copy files

perm_dir=775
perm_files=644
perm_exec=775

src=.
dst=

#part1

#Check SELinux enabled ?
sestatus -b 2>/dev/null | grep -q enabled
if test "$?" = "0" ; then
       echo "SELinux is enabled: this install won't work"
       echo "Please disable it before install..."
       exit
fi

#Check Loquendo Version
if [ -d /opt/Loquendo/LTTS7 ];then
  ltts=/opt/Loquendo/LTTS7
  if [ -f $ltts/bin/ssml2wav ];then
    lttsver=71
  else
    lttsver=7
  fi
elif [ -d /opt/LTTS  ];then
  lttsver=6
  ltts=/opt/LTTS
else
  echo "Loquendo not found !"
  exit 1
fi
echo "Using Loquendo $ltts..."
 
if [ ! $lttsver = "71" ];then
  #Save old binary for version 6 or 7
  if [ -f $ltts/bin/TTSFileGenerator ] && [ ! -f $ltts/bin/TTSFileGenerator.orig ];then
    mv $ltts/bin/TTSFileGenerator $ltts/bin/TTSFileGenerator.orig
  elif [ -f $ltts/bin/TTSFileGenerator.orig ]; then
    mv $ltts/bin/TTSFileGenerator $ltts/bin/TTSFileGenerator.bck.$(date +%Y-%m-%d)
  fi

  ARCH=`uname -m`
  if [ "$ARCH" = "x86_64" ] ; then  
    echo "Installing x86_64  binaries..."
    install -m $perm_exec $src/bin/TTSFileGenerator${lttsver}_64 $ltts/bin/TTSFileGenerator
  else
    echo "Installing i386 binaries..."
    install -m $perm_exec $src/bin/TTSFileGenerator${lttsver} $ltts/bin/TTSFileGenerator
  fi
else
  echo "Echo Version 7.1 do not need binaries... uses ssml2wav"
fi

#Select right config.php versions:
mv -v $dst/$wwwdirselect/tts/$TTSENGINE/config${lttsver}.php $dst/$wwwdirselect/tts/$TTSENGINE/config.php
rm -rf $dst/$wwwdirselect/tts/$TTSENGINE/config?.php



#part2
echo "Installing Web script..."
wwwdirselect=/var/www
echo $n "Enter apache web root directory[$wwwdirselect]: $c"
read wwwdiruser
if [ -n "$wwwdiruser" ]; then
	wwwdirselect=$wwwdiruser
fi
echo "Selected www dir : $wwwdirselect"

mkdir -p $dst/$wwwdirselect/tts/$TTSENGINE
install -m $perm_files $src/www/* $dst/$wwwdirselect/tts/$TTSENGINE

mkdir -p $dst/$wwwdirselect/tts/$TTSENGINE/html5media
install -m $perm_files $src/html5media/* $dst/$wwwdirselect/tts/$TTSENGINE/html5media/


echo "--- $TTSENGINE HTTP/TTS $mversion installation has finished ---"
