#!/bin/bash

ASTERISK_4="1.4.44"
ASTERISK_4_OLD="1.4.11"
ASTERISK_6_2="1.6.2.23"
ASTERISK_6_2_OLD="1.6.2.5"

src=.

echo "Verbio Asterisk module compiled from version 4.0"
echo "Module linked with Verbio Clients 8.03"

#Check SELinux enabled ?
sestatus -b 2>/dev/null | grep -q enabled
if test "$?" = "0" ; then
       echo "SELinux is enabled: this install won't work"
       echo "Please disable it before install..."
       exit
fi

#Found Asterisk
which -a asterisk 2>&1 >/dev/null
if [ ! "$?" = "0" ];then
  echo "Asterisk binary not found in PATH:$PATH"
  exit 1
fi

#Check Asterisk Version
asteriskversion=`asterisk -V|grep Asterisk| cut -d ' ' -f 2` 
#Asterisk Versions parsing
eval `echo $asteriskversion |  sed -n 's_\([0-9]*\)\.\([0-9]*\)\.\([0-9]*\).*_ astver1="\1" astver2="\2" astver3="\3"_p'`
[ "$astver2" == "6" ] && eval `echo $asteriskversion |  sed -n 's_[0-9]*\.[0-9]*\.[0-9]*\.\([0-9]*\).*_ astver4="\1"_p'`
echo "Current Asterisk : '$astver1.$astver2.$astver3.$astver4'"


case "$asteriskversion" in
  1.4.*)
    if [ "$astver3" -le `echo $ASTERISK_4_OLD|cut -d. -f3` ];then
      astflavour=$ASTERISK_4_OLD
    else
      astflavour=$ASTERISK_4
    fi
    ;;
  1.6.0.*)
    astflavour="1.6.0";;
  1.6.1.*)
    astflavour="1.6.1";;
  1.6.2.*)
    if [ "$astver4" -le `echo $ASTERISK_6_2_OLD|cut -d. -f4` ];then
      astflavour=$ASTERISK_6_2_OLD
    else
      astflavour=$ASTERISK_6_2
    fi
    ;;
  1.8*)
    astflavour="1.8";;
  *)
    echo "Unknow Asterisk Version: '$asteriskversion', exiting"
    exit 1;;
esac

if [ ! 1 -eq  `ls $src/modules/res_speech_verbio.so.asterisk_v${astflavour}* 2>/dev/null | grep 'res_speech_verbio.so' -c` ];then
  echo "No modules for this asterisk Version: '$astflavour', exiting"
  exit 1
else
  echo -n "Module found: "
  basename $src/modules/app_vxml.so.asterisk_v$astflavour*
fi

echo "Asterisk $asteriskversion installed."

#Check Asterisk Directory
asteriskdir=usr/lib/asterisk
if [ ! -d  $dst/$asteriskdir ];then
  echo -n "Asterisk directory not found (/$asteriskdir), please enter one:"
  read asteriskdiruser
  [ ! -d $dst/$asteriskdiruser ] && echo "$dst/$asteriskdiruser not found." && exit 1
  sed -e s_asteriskdir=.*_asteriskdir=${asteriskdiruser}_ uninstall.sh > uninstall.sh2 &&  mv uninstall.sh2 uninstall.sh
  asteriskdir=$asteriskdiruser
fi

echo "--- Verbio ASR for Asterisk Installation ---"
echo "--- Verbio Clients Version is 8.03 ---"
echo "--- Verbio ASR (res_speech) Version is 4.0 ---" 

# Copy files

perm_dir=775
perm_files=664
perm_exec=775

src=.
dst=

echo "Creating directories..."
mkdir -p $dst/var/lib/asterisk/verbio/text
mkdir -p $dst/var/lib/asterisk/verbio/gram
mkdir -p $dst/var/lib/asterisk/verbio/audio

# Check for directory existance
if test -d $dst/etc/asterisk ; then
echo "Installing configuration files..."
if test ! -f $dst/etc/asterisk/verbio.conf ; then
install -m $perm_files $src/etc/verbio.conf $dst/etc/asterisk/verbio.conf
else
install -m $perm_files $src/etc/verbio.conf $dst/etc/asterisk/verbio.conf.sample
fi

echo "Installing modules..."
install -m $perm_files $src/modules/res_speech_verbio.so.asterisk_v${astflavour}* $dst/$asteriskdir/modules/res_speech_verbio.so
fi

echo "--- Verbio for Asterisk installation has finished ---"
