/***************************************************************************
                                  test.c
                             -------------------
***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "nscube.h"

int CallBackSpeechData(const unsigned char *pData,
                       unsigned int cbDataSize,
                       PNSC_SOUND_DATA pSoundData,
                       void *pAppInstanceData)
{
    fwrite(pData,cbDataSize,1,(FILE *)pAppInstanceData);
    return 0;
}

int CallBackSpeechEvent(unsigned int nEventID,
                        unsigned int cbEventDataSize,
                        PNSC_EVENT_DATA pEventData,
                        void *pAppInstanceData)
{
    switch(nEventID)
    {
		case NSC_EVID_TEXT_STARTED :
		{
			NSC_EVENT_DATA_TextStarted *pEVTS = (NSC_EVENT_DATA_TextStarted *)pEventData;
			printf("IdText %i : Synthesis started.\n", (int)pEVTS->pUserData);
			break;
		}
		case NSC_EVID_TEXT_DONE :
		{
			NSC_EVENT_DATA_TextDone *pEVTD = (NSC_EVENT_DATA_TextDone *)pEventData;
			printf("IdText %i : Synthesis done.\n", (int)pEVTD->pUserData);
			break;
		}
    }
    return 0;
}

static void acapela_version()
{
    printf("  version: %s-%s-%s %s\n",
	   "0",
	   "0",
	   "0",
	   "0");
    printf("  i6net/Acapela Copyright 2009, all rights reserved\n");
}

static void acapela_usage()
{
    printf("acapela: text to audio file\n");
    acapela_version();
    printf("usage: acapela FILE [RAWFILE]\n"
           "  Converts text in TEXTFILE to a rawfile in RAWFILE\n"
           "  If text contains a space the it is treated as a literal\n"
           "  textstring and spoken, and not as a file name\n"
           "  Other options must appear before these options\n"
           "  --version   Output flite version number\n"
           "  --help      Output usage string\n"
           "  --voice     Acapela Voice\n"
           "  -o WAVEFILE Explicitly set output filename\n"
           "  -t TEXTFILE Explicitly set input filename\n"
           "  -i          Interactive mode\n");
    exit(0);
}

/****************************************************************************/

int main(int argc, char *argv[])
{
    nscHSRV					hSrv;					/* Handle of an Acapela Telecom server context returned by nscCreateServerContext */
    nscRESULT				Result;					/* Result of nsc functions */
    NSC_SRVINFO_DATA		SrvInfo;				/* This structure describes informations about server */
    NSC_FINDVOICE_DATA		FindVoice;				/* This structure describes a voice found by nscFindFirstVoice */
    nscHANDLE				hVoice;					/* Handle to be used in subsequent calls to nscFindNextVoice */
    nscHANDLE				hDispatch;				/* Handle will be passed to the event dispatching functions and returned by nscCreateDispatcher */
    nscHANDLE				hTTS;					/* Handle of channel returned by nscLockChannel */
    nscCHANID				ChId;					/* Id Of channel returned by nscInitChannel */
    NSC_EXEC_DATA			ExecData;				/* Informations using by a call to nscExecChannel */
    NSC_FINDVOICE_DATA 		*ptabFindVoice;
    int						idtabFindVoice = 0;
    char IPadr[20];
    int nbvoice;
    char voice[15];
    char tadd[500];
    char NomFich[20];
    FILE *f;
    FILE *t;
    
    char *arg_server = NULL;
    char *arg_voice = NULL;	
    char *arg_text = NULL;	
    char *arg_filename = NULL;		
	
	  int i;
	  int interactive = 1;
	
    for (i=1; i<argc; i++)
    {
      //printf("Arg : [%s] \n",argv[i]);      
      //if (!strcmp(argv[i],"-s"))
      //printf("OK \n");
      
	    if (!strcmp(argv[i],"--version"))
	    {
	      acapela_version();
	      return 1;
	    }
	    else if (!strcmp(argv[i],"-h") ||
		    !strcmp(argv[i],"--help") ||
		    !strcmp(argv[i],"-?"))
		  {
	      acapela_usage();
	    }
	    else if (!strcmp(argv[i],"-i"))
	    {
	      interactive = 1;
	    }
	    else if (((!strcmp(argv[i],"-server")) || (!strcmp(argv[i],"-s")))
		     && (i+1 < argc))
	    {
	       arg_server = argv[i+1];
	       i++;
	    }	    
	    else if ((!strcmp(argv[i],"-voice") || !strcmp(argv[i],"-v"))
		     && (i+1 < argc))
	    {
	       arg_voice = argv[i+1];
	       i++;
	    }
	    else if ((!strcmp(argv[i],"-text") || !strcmp(argv[i],"-t"))
		     && (i+1 < argc))
	    {
	       arg_text = argv[i+1];
	       interactive = 0;
	       i++;
	    }
	    else if (!strcmp(argv[i],"-f") && (i+1 < argc))
	    {
	       arg_filename = argv[i+1];
	       i++;
	    }
	    else if (arg_text)
	    arg_filename = argv[i];
	    else
	    arg_text = argv[i];
    }	
		 
    /* Connect */
    if (!arg_server)
    {
      printf("\nName or IP address of the Acapela Telecom server? : ");
      fgets(IPadr,sizeof(IPadr),stdin);
      IPadr[strlen(IPadr)-1] = '\0';
      /* nscCreateServerContext */
      printf("Connecting to %s ...   ",IPadr);
    }
    else
    {
      strcpy(IPadr, arg_server);
    } 	
	
	/* connect to server using old client-server communication protocol */
    if ((Result = nscCreateServerContext(NSC_AF_INET,0,IPadr,&hSrv)) == NSC_OK)

	/* or connect to server using old client-server communication protocol (from V6.000) */
//    if ((Result = nscCreateServerContextEx(NSC_AF_INET,6666,6665,IPadr,&hSrv)) == NSC_OK)	
	{
	      if (interactive)
        printf("Connected to %s\n",IPadr);
    }
    else
	{
        printf("ERROR: nscCreateServerContext return  %d \n",Result);
        return -1;
    }

    /* Dispatch */
    if (interactive)
    printf("Creating dispatcher...   ");
    if ((Result = nscCreateDispatcher(&hDispatch)) == NSC_OK)
	  {
	      if (interactive)
        printf("Dispatcher created\n");
    }
    else
	{
        printf("ERROR: nscCreateDispatcher return  %d \n",Result);
        return -1;
    }



    /* Enumeration */
    if ((Result = nscGetServerInfo(hSrv, &SrvInfo)) != NSC_OK)
	{
		printf("ERROR: nscGetServerInfo return %d \n",Result);
		return -1;
    }
    
    ptabFindVoice = (NSC_FINDVOICE_DATA *)malloc(sizeof(NSC_FINDVOICE_DATA) * SrvInfo.nMaxNbVoice);
    if (ptabFindVoice == NULL)
	{
        printf("ERROR: not enough memory\n");
        return(-1);
    }
    printf("Searching voice...   ");
    if ((Result = nscFindFirstVoice(hSrv,NULL,0,0,0,&FindVoice,&hVoice)) == NSC_OK)
	{
        ptabFindVoice[idtabFindVoice++] = FindVoice;
        while((Result = nscFindNextVoice(hVoice,&FindVoice)) == NSC_OK)
		{
            ptabFindVoice[idtabFindVoice++] = FindVoice;
		}
    }
    else
	{
        printf("ERROR: nscFindFirstVoice return  %d \n",Result);
        return -1;
    }
    nscCloseFindVoice(hVoice);
    printf("%d voices found:\n",idtabFindVoice);
	
    nbvoice = idtabFindVoice;
    idtabFindVoice = 0;
    if (!arg_voice)
    {    
    while (nbvoice > 0) 
	{
		printf("  %s\n",ptabFindVoice[idtabFindVoice].cVoiceName);
		idtabFindVoice++;
		nbvoice--;
    }
    }

    /* Init channel  */
    if (!arg_voice)
    {
    printf("\n");
    printf("Enter a voice name? : ");
    fgets(voice,sizeof(voice),stdin);
    /*Voice name must match exactly the enumerated value so terminating \n char must be removed */
    voice[strlen(voice)-1] = '\0';
    printf("Channel initialising with %s ... \n",voice);
    }
    else
    {
      strcpy(voice, arg_voice);    
    }
    if ((Result = nscInitChannel(hSrv,voice,0,0,hDispatch,&ChId)) == NSC_OK)
	{
	      if (interactive)
        printf("Channel initialised\n");
    }
    else
	{
        printf("ERROR: nscInitChannel return  %d \n",Result);
        return -1;
    }



    /* Lock channel */
	  if (interactive)
    printf("Channel locking...   ");
    if( (Result = nscLockChannel(hSrv,ChId,hDispatch,&hTTS)) == NSC_OK)
	{
    	  if (interactive)
        printf("Channel locked\n");
    }
    else
	{
        printf("ERROR: nscLockChannel return  %d \n",Result);
        return -1;
    }

    /* AddText channel */
    if (interactive)
    printf("\n");
    tadd[0]='\0';
    
    if (arg_text)
    {
      if (interactive)
      printf("Text file...   \n", arg_text);
      
      if ((t = fopen(arg_text,"r")) != NULL)
      {
           int IdText = 1;

           while(fgets(tadd,sizeof(tadd),t)) 
           {  
              if (interactive)
              printf("Text %i adding...   \n", IdText);
              
              if ((Result = nscAddTextEx(hTTS, "UTF-8", tadd, strlen(tadd),(void *)IdText)) == NSC_OK)
	            {
	              if (interactive)
                printf("Text %i added\n", IdText);
              }
              else
	            {
                fclose(t);   
                printf("ERROR: nscAddText return  %d \n",Result);
                return -1;
              }
              
              IdText++;           
           }   
           
           fclose(t);   
      }    
		  else
		  {
            printf("ERROR: unable to open %s \n",arg_text);
            return -1;
		  }      
    }
    else
    {
    while(tadd[0] == '\0')
	{
		printf("Text to add to channel? : ");
		fgets(tadd,sizeof(tadd),stdin);
        tadd[strlen(tadd)-1]='\0';
    }
    
    int IdText = 1;
    printf("Text %i adding...   ", IdText);
    if ((Result = nscAddText(hTTS,tadd,(void *)IdText)) == NSC_OK)
	{
        printf("Text %i added\n", IdText);
    }
    else
	{
        printf("ERROR: nscAddText return  %d \n",Result);
        return -1;
    }
    }

    /* ExecChannel */
    ExecData.pfnSpeechData = CallBackSpeechData;
    ExecData.pfnSpeechEvent = CallBackSpeechEvent;
    ExecData.ulEventFilter = NSC_EVTBIT_TEXT;
    ExecData.bEventSynchroReq = 0;
    ExecData.vsSoundData.uiSize = 0;
    ExecData.vsSoundData.pSoundBuffer = NULL;
	  if (interactive)    
    printf("\n");
    NomFich[0] = '\0';
    if (arg_filename)
    {
      strcpy(NomFich, arg_filename);
    }
    else
    while (NomFich[0] == '\0')
	{
		printf("Name of file to store sound? : ");
		fgets(NomFich,sizeof(NomFich),stdin);
        NomFich[strlen(NomFich)-1] = '\0';
    }
    
    if ((f = fopen(NomFich,"w")) != NULL)
	{
		ExecData.pAppInstanceData=(void *)f;
        printf("Channel executing...\n");
        if ((Result = nscExecChannel(hTTS,&ExecData)) == NSC_OK)
		{
            printf("Channel Executed\n");
		}
		else
		{
            printf("ERROR: nscExecChannel return  %d \n",Result);
            return -1;
		}
		fclose(f);
    }
    else
	{
		printf("ERROR:PERMISSION DENIED\n");
    }

    /* Unlock channel */
    printf("Channel unlocking...   ");
    if ((Result = nscUnlockChannel(hTTS)) == NSC_OK)
	{
        printf("Channel unlocked\n");
    }
    else
	{
        printf("ERROR: nscUnlockChannel return  %d \n",Result);
        return -1;
    }
	
    /* Close channel */
    printf("Channel closing...   ");
    if( (Result = nscCloseChannel(hSrv,ChId))==NSC_OK){
        printf("Channel closed\n");
    }
    else{
        printf("ERROR: nscCloseChannel return  %d \n",Result);
        return -1;
    }
	
			
	
    /* DeleteDispatcher */
    printf("Dispatcher deleting...   ");
    if ((Result = nscDeleteDispatcher(hDispatch)) == NSC_OK)
	{
        printf("Dispatcher Deleted\n");
    }
    else
	{
        printf("ERROR: nscDeleteDispatcher return  %d \n",Result);
        return -1;
    }

    /* ReleaseServer */
    printf("Disconnecting...   ");
    if ((Result = nscReleaseServerContext(hSrv)) == NSC_OK)
	{
        printf("Disconnected\n");
    }
    else
	{
        printf("ERROR: nscReleaseServerContext return  %d \n",Result);
        return -1;
    }

    return 0;
}
