#!/bin/bash
mversion=1.1
TTSENGINE=lumenvox

echo "--- $TTSENGINE HTTP/TTS $mversion Installation ---"

# Copy files

perm_dir=775
perm_files=644
perm_exec=775

src=.
dst=

ARCH=`uname -m`
if [ "$ARCH" = "x86_64" ] ; then  
  echo "no x86_64 version for SimpleTTSClient, try to compile from $src/src"
else
  if [ -f /usr/bin/SimpleTTSClient ];then
    echo "SimpleTTSClient already present in /usr/bin"
  else
    echo "Installing i386 SimpleTTSClient in /usr/bin"
    install -m $perm_exec $src/bin/SimpleTTSClient /usr/bin/
  fi
fi

#part1
#part2
echo "Installing Web script..."
wwwdirselect=/var/www
echo -n "Enter apache web root directory[$wwwdirselect]: "
read wwwdiruser
if [ -n "$wwwdiruser" ]; then
	wwwdirselect=$wwwdiruser
fi
echo "Selected www dir : $wwwdirselect"

mkdir -p $dst/$wwwdirselect/tts/$TTSENGINE
install -m $perm_files $src/www/* $dst/$wwwdirselect/tts/$TTSENGINE

mkdir -p $dst/$wwwdirselect/tts/$TTSENGINE/html5media
install -m $perm_files $src/html5media/* $dst/$wwwdirselect/tts/$TTSENGINE/html5media/


echo "--- $TTSENGINE HTTP/TTS $mversion installation has finished ---"
