#!/bin/sh
# vim: set expandtab tabstop=4 shiftwidth=4 autoindent smartindent: 
mdate=`date +%Y-%m-%d`

# Where is Apache document root directory

echo "--- CDR Analyser for Asterisk Installation ---"

# Copy files

perm_dir=775
perm_files=664
perm_exec=775
perm_all=666

src=.
dst=

echo "Creating database cdr ..."
echo "Please enter mysql root password or press 'Return', if it's not setted :"
mysql -p  <scripts/create_cdr.sql
if [ $? != 0 ]
then
    echo "*** ERROR: Unable to create cdr database!"
    echo "Installation aborted !"
    exit 1
else
    echo "ok."
fi

wwwdirselect="/var/www"
echo -n "Enter apache web root directory[$wwwdirselect]: "
read wwwdiruser
if [ -n "$wwwdiruser" ]; then
      wwwdirselect=$wwwdiruser
  fi
  echo "Selected www dir : $wwwdirselect"


echo "Installing Asterisk-Stat Module"
if [ -d $wwwdirselect/stats ]; then
    echo -n "$wwwdirselect/stats exists: Clean it ? [N/y]"
    read resp
    if [ -z "$resp" ] || [ "$resp" != "y" ];then
        exit
    fi
fi
rm -rf $wwwdirselect/stats
cp -rp stats $wwwdirselect

# specific for log filters
mkdir $wwwdirselect/stats/downloads
chown www-data:www-data $wwwdirselect/stats/downloads
ln -s /tmp/logContent $wwwdirselect/stats/logContent
ln -s /tmp/cacheContent $wwwdirselect/stats/cacheContent


echo "Configuring Asterisk-Addons Modules..."
install -m $perm_files $src/configs/cdr_mysql.conf $dst/etc/asterisk/cdr_mysql.conf

echo "Configuring Apache ..."
for apachedir in /etc/httpd /etc/apache2 /etc/apache;do
    if [ -d $apachedir ];then
        apachedirselect=$apachedir
    fi
done
echo -n "Enter apache web root directory[$apachedirselect]: "
read apachediruser
if [ -n "$apachediruser" ]; then
   apachedirselect=$apachediruser
fi
echo "Selected root dir : $apachedirselect"
if [ -d $apachedirselect ];then
    if [ -d $apachedirselect/conf.d ];then
        sed -e "s|__INSTALLDIR__|$wwwdirselect|" scripts/stats-cdr-apache.conf > $apachedirselect/conf.d/cdr-stats.conf
        echo "You must restart apache ..."
    else
        echo "No conf.d directory, unable ton continue"
    fi
else
    echo "Selected root dir not found!"
fi

echo
echo "Default password for admin is : admin2011!, please change it!"
