DROP DATABASE IF EXISTS cdr;
CREATE DATABASE cdr;

USE cdr;

GRANT ALL on cdr.* to 'cdr'@'localhost' identified by 'password';
FLUSH PRIVILEGES;

CREATE TABLE `cdr` (
  `calldate` datetime NOT NULL default '0000-00-00 00:00:00',
  `clid` varchar(80) NOT NULL default '',
  `src` varchar(80) NOT NULL default '',
  `dst` varchar(80) NOT NULL default '',
  `dcontext` varchar(80) NOT NULL default '', 
  `channel` varchar(80) NOT NULL default '',
  `dstchannel` varchar(80) NOT NULL default '',
  `lastapp` varchar(80) NOT NULL default '',
  `lastdata` varchar(80) NOT NULL default '',
  `duration` int(11) NOT NULL default '0',
  `billsec` int(11) NOT NULL default '0',
  `disposition` varchar(45) NOT NULL default '', 
  `amaflags` int(11) NOT NULL default '0',
  `accountcode` varchar(20) NOT NULL default '',
  `userfield` varchar(255) NOT NULL default '',
  `uniqueid` varchar(32) NOT NULL default '');


ALTER TABLE `cdr` ADD INDEX ( `calldate` );

ALTER TABLE `cdr` ADD INDEX ( `dst` );

ALTER TABLE `cdr` ADD INDEX ( `accountcode` ); 

CREATE TABLE `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(25) NOT NULL,
  `password` varchar(40) NOT NULL COMMENT 'SHA1+SALT',
  `admin` tinyint(4) NOT NULL,
  `userinfos` varchar(500) NOT NULL,
  `updated` datetime NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`) );

-- Default admin/admin2011!
INSERT INTO `users` (`id`, `username`, `password`, `admin`, `userinfos`, `updated`, `created`) VALUES
(1, 'admin', 'e0d5b086488285fd85f67fb9e06110dbf37b948a', 1, 'a:2:{s:6:"search";s:0:"";s:7:"discols";s:0:"";}', '2011-03-24 11:13:29', '2011-02-21 10:49:24'),
(2, 'i6net', '8bca56f19a4363f4836294d42cafc42e4e25f719', 1, 'a:2:{s:6:"search";s:0:"";s:7:"discols";s:0:"";}', '2011-03-24 11:06:50', '2011-03-24 11:06:50');

