<?php
//For Auth
require_once(dirname(__FILE__) . "/lib/defines.php");

error_reporting ( E_ALL );
//error_reporting(E_ERROR | E_WARNING | E_PARSE);
#Debug print to /tmp/file.log
define("DEBUG", true );
$SPOOLDIR="/var/spool/asterisk/monitor";
$FFMPEG="/usr/local/bin/ffmpeg";


function debug($message){
  if(defined('DEBUG')){
    file_put_contents("/tmp/file.log",$message."\n",FILE_APPEND);
    //echo "<pre>DEBUG: $message</pre>\n";
    //flush();
  }
}

function headerdebug($header){
  if(defined('DEBUG'))
    debug(" HEADER => '$header'");
  header($header);
}

function getorpost($varname,&$var=null){
  if(isset($_POST[$varname])){
    $var=$_POST[$varname];
    return true;
  }elseif(isset($_GET[$varname])){
    $var=$_GET[$varname];
    return true;
  }else
    return false;
}

function httperror($num=400){
  switch($num){
    case 404:
      headerdebug("HTTP/1.1 404 Not Found");
      break;
    case 400:
    default: 
      headerdebug("HTTP/1.1 400 Bad Request");
  }
  exit();
}



if(!defined('DEBUG'))
  error_reporting(0);

debug("Mode debug enabled");
debug("Request: ".print_r($_REQUEST,true));
debug("Request: ".print_r($_SERVER,true));


if(getorpost('file',$file)){
   if(file_exists("${SPOOLDIR}/${file}")){
     if(!getorpost('format',$format))
       $format="mp3";
    debug("file : ${SPOOLDIR}/${file}  format: ${format}");
  }else
    httperror(404);	  

}else
  httperror(400);

switch ($format) {
  case "mp3":
    headerdebug("Content-Type: audio/mpeg");
    break;
  case "ogg":
    headerdebug("Content-Type: audio/ogg");
    break;
  case "wav":
    headerdebug("Content-Type: audio/x-wav");
    break;
  default:
    httperror(400);
    break;
}

//remove old extension and special chars 
$simplefilename=str_replace(array(';',','), "_",substr($file,0,-4));
headerdebug('Content-Disposition: attachment; filename="'.$simplefilename.'.'.$format.'"');

debug("USER AGENT: ".print_r($_SERVER['HTTP_USER_AGENT'],true));

switch ($format) {
  case "mp3":
    $cmd=' cat '.$SPOOLDIR."/".escapeshellcmd($file)." | ".$FFMPEG.' -i - -ac 2 -ar 44100 -ab 64k -f '.$format.' -';
    break;
  case "ogg":
    $cmd=' cat '.$SPOOLDIR."/".escapeshellcmd($file)." | ".$FFMPEG.' -strict experimental -i - -ac 2 -ar 44100 -aq 10 -acodec libvorbis -f '.$format.' -';
    break;
  default:
    $cmd=' cat '.$SPOOLDIR."/".escapeshellcmd($file);
    break;
}

debug("CMD: $cmd",true);

passthru($cmd,$ret);

if($ret !== 0)
  httperror(404);
else
  exit;

// vim: set filetype=php expandtab tabstop=2 shiftwidth=2 autoindent smartindent:
?>
