<?php	


	/***********************************************************************************/
	/*************                                                         *************/
	/*********                    REGEXP FOR STATIC FILTERS                    *********/
	/*************                                                         *************/
	/***********************************************************************************/
	
	$staticErrorExpr = array (
		array('/SEVERE/', "SubExpr: severeSubExpr"),
		array('/CRITICAL/', "Show", "color:#990000;font-family:Courier;"),
		array('/WARNING/', "Show",  "color:#CC6600;font-family:Courier;"),
		array('/FetchDocument - Parse error in file/', "Link", "color:#8A0808;font-family:Courier;"),
		array('/Parse error/i', "Show",  "color:#8A0808;font-family:Courier;"),
		array('/^(?=.*error)(?=.*EVENT).*$/i', "Show",  "color:#8A0808;font-family:Courier;"),
		array('/FetchDocument - buffer is saved in/', "Link", "color:#FF00FF;font-family:Courier;"),
		
	);
	
	$staticMSGErrExpr = array (
		array('/SEVERE/', "SubExpr: severeSubExpr"),
		array('/CRITICAL/', "Show",  "color:#990000;font-family:Courier;font-weight:bold;"),
		array('/WARNING/', "Show",  "color:#CC6600;font-family:Courier;font-weight:bold;"),
		array('/FetchDocument - Parse error in file/', "Link", "color:#8A0808;font-family:Courier;"),
		array('/Parse error/i',  "Show", "color:#8A0808;font-family:Courier;font-weight:bold;"),
		array('/^(?=.*error)(?=.*EVENT).*$/i', "Show", "color:#8A0808;font-family:Courier;font-weight:bold;"),
		array('/transfer\|session/', "Show",  "color:#CC00FF;font-family:Courier;font-weight:bold;"),
		array('/MSG > EVT 1/', "Skip: 0"),	// Pay attention to the precedence with strings and substrings:
		array('/MSG/', "Show",  "color:#000000;font-family:Courier;font-weight:normal;"),			// this is shorter, so it must be after the previous one
		array('/FetchDocument - buffer is saved in/', "Link", "color:#FF00FF;font-family:Courier;"),
	);
	
	$staticRecognizeMSGErrExpr = array (
		array('/inputmode=/i', "SubExpr: recognizeSubExprBold"),	// "SubExpr" is a tag that means "ok, you matched with this,
																// now search which one of the next regexp matches better"
		array('/SEVERE/', "SubExpr: severeSubExpr"),
		array('/CRITICAL/', "Show",  "color:#990000;font-family:Courier;font-weight:bold;"), // We define the entire style for each regexp
		array('/WARNING/',  "Show", "color:#CC6600;font-family:Courier;font-weight:bold;"),
		array('/FetchDocument - Parse error in file/', "Link", "color:#8A0808;font-family:Courier;"),
		array('/Parse error/i',  "Show", "color:#8A0808;font-family:Courier;font-weight:bold;"),
		array('/^(?=.*error)(?=.*EVENT).*$/i', "Show",  "color:#8A0808;font-family:Courier;font-weight:bold;"),
		array('/transfer\|session/', "Show",  "color:#CC00FF;font-family:Courier;font-weight:bold;"),
		array('/Queuing TTS/', "Show",  "color:#999900;font-family:Courier;font-weight:bold;"),
		array('/VXIrecGrammarControler\|MSG>3/', "Link", "color:blue;font-family:Courier;font-weight:normal;"),
		array('/MSG > EVT 1/', "Skip: 0"),												// Pay attention to the precedence with strings and substrings:
		array('/MSG/', "Show",  "color:#000000;font-family:Courier;font-weight:normal;"),		// this is shorter, so it must be after the previous one
		array('/FetchDocument - buffer is saved in/', "Link", "color:#FF00FF;font-family:Courier;"),
	);
		
	$staticAllExpr = array (
		array('/Waiting CALL/i', "Show",  "color:#000000;font-family:Courier;font-weight:bold;"),
		array('/SEVERE/', "SubExpr: severeSubExpr"),
		array('/CRITICAL/i', "Show",  "color:#990000;font-family:Courier;font-weight:bold;"),
		array('/WARNING/i', "Show",  "color:#CC6600;font-family:Courier;font-weight:bold;"),
		array('/inputmode=/i', "SubExpr: recognizeSubExpr"),
		array('/FetchDocument - Parse error in file/', "Link", "color:#8A0808;font-family:Courier;font-weight:bold;"),
		array('/Parse error/i', "Show",  "color:#8A0808;font-family:Courier;font-weight:bold;"),
		array('/^(?=.*error)(?=.*EVENT).*$/i', "Show",  "color:#8A0808;font-family:Courier;font-weight:bold;"),
		array('/\|2000\|Read\|exiting: 0, 400/',"Skip: 0"),
		array('/\|3000\|SBinetChannel::Read\|exiting, returned 0/',"Skip: 0"),
		array('/\|3000\|SBinetChannel::Read\|entering/',"Skip: 0"),
		array('/\|2000\|Read\|entering: /',"Skip: 0"),
		array('/^(?=.*\|2003\|Read\|swi:swi:SBinet:)(?=.*rc = 0).*$/i',"Skip: 0"),
		array('/\|2000\|Write\|exiting: 0, 400/',"Skip: 0"),
		array('/com.speechworks.vxi\|URL: /', "Link", "color:blue;font-family:Courier;font-weight:normal;"),
		array('/VXIrecGrammarControler\|MSG>3/', "Link", "color:blue;font-family:Courier;font-weight:normal;"),
		array('/transfer\|session/', "Show",  "color:#CC00FF;font-family:Courier;font-weight:bold;"),
		array('/Queuing TTS/', "Show",  "color:#999900;font-family:Courier;font-weight:bold;"),
		array('/MSG/', "Show",  "color:blue;font-family:Courier;font-weight:bold;"),
		array('/FetchDocument - buffer is saved in/', "Link", "color:#FF00FF;font-family:Courier;font-weight:normal;"),
		array('/Dumping HTTP messages/', "Link", "color:#FF0000;font-family:Courier;font-weight:normal;"),
		array('/\|2\d{3}\|/',"Split", "color:#FF0000;font-family:Courier;font-weight:normal;"),	// previously 000000
		array('/\|3\d{3}\|/',"Split", "color:#FF0000;font-family:Courier;font-weight:normal;"), 
		array('/\|4\d{3}\|/',"Split", "color:#006600;font-family:Courier;font-weight:normal;"),
		array('/\|5\d{3}\|/',"Split", "color:#0066CC;font-family:Courier;font-weight:normal;"),
		array('/\|6\d{3}\|/',"Split", "color:#0066CC;font-family:Courier;font-weight:normal;"),	// previously CCCC00
		array('/\|7\d{3}\|/',"Split", "color:#0066CC;font-family:Courier;font-weight:normal;"),	// previously 00CCCC
		array('/\|8\d{3}\|/',"Split", "color:#FF00FF;font-family:Courier;font-weight:normal;"),
		array('/\|9\d{3}\|/',"Split", "color:#C0C0C0;font-family:Courier;font-weight:normal;"),
		array('/\|1\d{4}\|/',"Split", "color:#500000;font-family:Courier;font-weight:normal;"),
		
	);
	

	/************************************************************************************/
	/*************                                                         **************/
	/*********                    REGEXP FOR DYNAMIC FILTERS                    *********/
	/*************                                                         **************/
	/************************************************************************************/
	
	$dynamicAllExpr = array (
		array('/CRITICAL/i', "Show", "#990000"),
		array('/WARNING/i', "Show", "#CC6600"),
		array('/inputmode=/i', "SubExpr: recognizeSubExprBold"),	// "SubExpr" is a tag that means "ok, you matched with this,
																// now search which one of the next regexp matches better"
		array('/FetchDocument - Parse error in file/', "Link", "color:#8A0808;font-family:Courier;font-weight:bold;"),
		array('/Parse error/i', "Show", "#8A0808"),
		array('/^(?=.*:SBinet\|219\|)(?=.*URL).*$/i', "SubExpr: sbinetURLSubExpr"),
		array('/^(?=.*error)(?=.*EVENT).*$/i', "Show", "#8A0808"),
		array('/\|2000\|Read\|exiting: 0, 400/',"Skip: 0"),		// "Skip" is a tag that means "ok, you matched with this,
																// don't print it and don't print the next X lines"
		array('/\|3000\|SBinetChannel::Read\|exiting, returned 0/',"Skip: 0"),
		array('/\|3000\|SBinetChannel::Read\|entering/',"Skip: 0"),
		array('/\|2000\|Read\|entering: /',"Skip: 0"),
		array('/^(?=.*\|2003\|Read\|swi:swi:SBinet:)(?=.*rc = 0).*$/i',"Skip: 0"),
		array('/\|2000\|Write\|exiting: 0, 400/',"Skip: 0"),
		array('/com.speechworks.vxi\|URL: /', "Link", "color:blue;font-family:Courier;font-weight:normal;"),
		array('/VXIrecGrammarControler\|MSG>3/', "Link", "color:blue;font-family:Courier;font-weight:normal;"),
		array('/transfer\|session/', "Show", "#CC00FF"),
		array('/Queuing TTS/', "Show", "#999900"),
		array('/Waiting CALL/i', "Show", "#000000"),
		array('/SEVERE/', "SubExpr: severeSubExpr"),
		array('/MSG/', "Show", "blue"),
		array('/FetchDocument - buffer is saved in/', "Link", "color:#FF00FF;font-family:Courier;font-weight:normal;"),
		array('/Dumping HTTP messages/', "Link", "color:#FF0000;font-family:Courier;font-weight:normal;"),
		array('/\|2\d{3}\|/',"Split", "color:#FF0000;font-family:Courier;font-weight:normal;"),	// previously 000000
		array('/\|3\d{3}\|/',"Split", "color:#FF0000;font-family:Courier;font-weight:normal;"), 
		array('/\|4\d{3}\|/',"Split", "color:#006600;font-family:Courier;font-weight:normal;"),
		array('/\|5\d{3}\|/',"Split", "color:#0066CC;font-family:Courier;font-weight:normal;"),
		array('/\|6\d{3}\|/',"Split", "color:#0066CC;font-family:Courier;font-weight:normal;"),	// previously CCCC00
		array('/\|7\d{3}\|/',"Split", "color:#0066CC;font-family:Courier;font-weight:normal;"),	// previously 00CCCC
		array('/\|8\d{3}\|/',"Split", "color:#FF00FF;font-family:Courier;font-weight:normal;"),
		array('/\|9\d{3}\|/',"Split", "color:#C0C0C0;font-family:Courier;font-weight:normal;"),
		array('/\|1\d{4}\|/',"Split", "color:#500000;font-family:Courier;font-weight:normal;"),
	);
	
	$dynamicErrorsExpr = array (
		array('/SEVERE/', "SubExpr: severeSubExpr"),
		array('/CRITICAL/', "Show", "color:#990000;font-family:Courier;"),
		array('/WARNING/', "Show", "color:#CC6600;font-family:Courier;"),
		array('/FetchDocument - Parse error in file/', "Link", "color:#8A0808;font-family:Courier;"),
		array('/Parse error/i', "Show", "color:#8A0808;font-family:Courier;"),
		array('/^(?=.*error)(?=.*EVENT).*$/i', "Show", "color:#8A0808;font-family:Courier;"),
		array('/FetchDocument - buffer is saved in/', "Link", "color:#FF00FF;font-family:Courier;"),
		
	);
	
	$dynamicMSGErrExpr = array (
		array('/SEVERE/', "SubExpr: severeSubExpr"),
		array('/CRITICAL/', "Show", "color:#990000;font-family:Courier;font-weight:bold;"),
		array('/WARNING/', "Show", "color:#CC6600;font-family:Courier;font-weight:bold;"),
		array('/FetchDocument - Parse error in file/', "Link", "color:#8A0808;font-family:Courier;"),
		array('/Parse error/i', "Show", "color:#8A0808;font-family:Courier;font-weight:bold;"),
		array('/^(?=.*error)(?=.*EVENT).*$/i', "Show", "color:#8A0808;font-family:Courier;font-weight:bold;"),
		array('/transfer\|session/', "Show", "color:#CC00FF;font-family:Courier;font-weight:bold;"),
		array('/MSG > EVT 1/', "Skip: 0"),	// Pay attention to the precedence with strings and substrings:
		array('/MSG/', "Show", "color:#000000;font-family:Courier;font-weight:normal;"),			// this is shorter, so it must be after the previous one
		array('/FetchDocument - buffer is saved in/', "Link", "color:#FF00FF;font-family:Courier;"),
	);
	
		
	$dynamicRecognizeMSGErrExpr = array (
		array('/inputmode=/i', "SubExpr: recognizeSubExprBold"),	// "SubExpr" is a tag that means "ok, you matched with this,
																// now search which one of the next regexp matches better"
		array('/SEVERE/', "SubExpr: severeSubExpr"),
		array('/CRITICAL/', "Show",  "color:#990000;font-family:Courier;font-weight:bold;"), // We define the entire style for each regexp
		array('/WARNING/',  "Show", "color:#CC6600;font-family:Courier;font-weight:bold;"),
		array('/FetchDocument - Parse error in file/', "Link", "color:#8A0808;font-family:Courier;"),
		array('/Parse error/i',  "Show", "color:#8A0808;font-family:Courier;font-weight:bold;"),
		array('/^(?=.*error)(?=.*EVENT).*$/i', "Show",  "color:#8A0808;font-family:Courier;font-weight:bold;"),
		array('/transfer\|session/', "Show",  "color:#CC00FF;font-family:Courier;font-weight:bold;"),
		array('/Queuing TTS/', "Show",  "color:#999900;font-family:Courier;font-weight:bold;"),
		array('/VXIrecGrammarControler\|MSG>3/', "Link", "color:blue;font-family:Courier;font-weight:normal;"),
		array('/MSG > EVT 1/', "Skip: 0"),												// Pay attention to the precedence with strings and substrings:
		array('/MSG/', "Show",  "color:#000000;font-family:Courier;font-weight:normal;"),		// this is shorter, so it must be after the previous one
		array('/FetchDocument - buffer is saved in/', "Link", "color:#FF00FF;font-family:Courier;"),
	);
	

	/********************************************************************/
	/*************                                         **************/
	/*********                    SUB-REGEXP                    *********/
	/*************                                         **************/
	/********************************************************************/
	
	$recognizeSubExpr = array (
		array('/dtmf/i', "#339900"),
		array('/voice/i', "#009933"),
	);
	
	$recognizeSubExprBold = array (
		array('/dtmf/i', "color:#339900;font-family:Courier;font-weight:bold;"),
		array('/voice/i', "color:#009933;font-family:Courier;font-weight:bold;"),
	);
	
	
	$severeSubExpr = array (
		array('/^(?=.*:SBinet\|219\|)(?=.*URL).*$/i', "color:purple;font-family:Courier;"),	
		array('/[\s\S]*/', "color:#CC3300;font-family:Courier;"),	// this one must be the last one because it matches with everything
	);
	
	$severeSubExprBold = array (
		array('/^(?=.*:SBinet\|219\|)(?=.*URL).*$/i', "color:purple;font-family:Courier;font-weight:bold;"),	
		array('/[\s\S]*/', "color:#CC3300;font-family:Courier;font-weight:bold;"),	// this one must be the last one because it matches with everything
	);
	
	$subExpr = array(
		"severeSubExpr"=> $severeSubExpr,
		"severeSubExprBold"=> $severeSubExprBold,
		"recognizeSubExpr"=> $recognizeSubExpr,
		"recognizeSubExprBold"=> $recognizeSubExprBold,
	);
	
?>