<?php 
	@session_start();
	
	if (!isset($_SESSION['file'])) // File to read the traces from
		$file="/tmp/log.txt";
	else
		$file = $_SESSION['file'];
		
	$path = $_SESSION['path'];
	$GLOBALS['phpFileName'] = basename(__FILE__); 	// In this case staticRecognizeMSGErr.php
	$GLOBALS['path'] = $_SESSION['path'];			// It will be used in the staticHeader.php
	session_write_close(); 	// We close the session because the process is too long
							// and the other tabs would be locked
	
	$GLOBALS['moment'] = date("Ymd_H_i_s");			// This value is written in the name of the downloadable file
	$GLOBALS['filterFileName'] = "staticRecognizeMSGErr";
	$GLOBALS['filterName'] = "Static Recognize, MSG and Errors";
	
	include('staticHeader.php');
	include('regularExpressions.php');
	
	$caseExpr = "staticRecognizeMSGErrExpr";	// Here starts the main array of regexp
	
	
	// We include the function in charge of matching the regexp with the readed lines.
	include('staticLineTreatment.php');
	
?>

<div id="traces">
<?php

//header('Content-Type: text/plain');
//header("Content-Disposition: inline; filename=log.txt");
//header("Content-Disposition: inline");

// Downloadable file:
$fileWrite = $_SESSION['path'].'downloads/'.$GLOBALS['moment'].basename(__FILE__, ".php").'.txt';
// Deprecated:
//	$dotsCounter = 0;
//	$lineCounter = 0;
$handle = fopen($file, "r");			// Read handler
$handleWrite = fopen($fileWrite, "w");	// Write handler
if ($handle && $handleWrite) {
    while (($line = fgets($handle)) !== false) {
		$lineCounter++;
		
		/****  Treatment of $line ****/
		$parts = explode("|", $line);
		if(	$parts[3] >= 2000 && $parts[3] <= $offsetCache	||
			$parts[3] >= 3000 && $parts[3] <= $offsetInet	||
			$parts[3] >= 4000 && $parts[3] <= $offsetJSI	||
			$parts[3] >= 5000 && $parts[3] <= $offsetPrompt	||
			$parts[3] >= 6000 && $parts[3] <= $offsetRec	||
			$parts[3] >= 7000 && $parts[3] <= $offsetTel	||
			$parts[3] >= 8000 && $parts[3] <= $offsetVxi	||
			$parts[3] >= 9000 && $parts[3] <= $offsetObject	||
			$parts[3] >= 10000 && $parts[3] <= $offsetClient	||
			$parts[3] == "SEVERE"	||	$parts[3] == "CRITICAL"	||	$parts[3] == "WARNING"){
			lineTreatmentFunction(${$caseExpr}, $line, $handleWrite, $subExpr);
		}
		/**** End of $line's treatment ****/
		
		ob_flush();
		flush();		
		/*
		if ($lineCounter%100== 0)
			usleep(40); 
		*/
    }
	fclose($handle);
	fclose($handleWrite);
} else {
    // error opening the file.
	echo "Error opening the file with the whole content of the logs: $file<br>or the file to dump the output: $fileWrite";	
	echo "<br>$file handler: $handle<br>";
	echo "<br>$fileWrite handler: $handleWrite";
	fclose($handle);
	fclose($handleWrite);
}
	


?>
<br>
</div>

<a class="scrollup" href="#">Scroll</a>